"""
<problem>
Problem Link: https://leetcode.com/problems/arithmetic-slices/

An integer array is called arithmetic if it consists of at least three elements and if the difference between any two consecutive elements is the same.
For example, [1,3,5,7,9], [7,7,7,7], and [3,-1,-5,-9] are arithmetic sequences.
Given an integer array nums, return the number of arithmetic subarrays of nums.
A subarray is a contiguous subsequence of the array.

Example 1:
Input: nums = [1,2,3,4]
Output: 3
Explanation: We have 3 arithmetic slices in nums: [1, 2, 3], [2, 3, 4] and [1,2,3,4] itself.

Example 2:
Input: nums = [1]
Output: 0

Constraints:
1 <= nums.length <= 5000
-1000 <= nums[i] <= 1000
</problem>
<bug_fixes>
Replace `<=` with `<` on line 3.
Replace `nums[0] - nums[1]` with `float('inf')` on line 5.
Replace `!=` with `==` on line 5.
</bug_fixes>
On line 3, the base case condition if len(nums) <= 3: is incorrect. It should be if len(nums) < 3: because an arithmetic sequence requires at least three elements.
On line 5, the initial value of diff is calculated as nums[0] - nums[1], assuming that the first two elements are different. However, this assumption may not always be valid, and it's better to initialize diff with a sentinel value like float('inf').
On line 9,  The condition `if nums[index] - nums[index-1] != diff:` should be `if nums[index] - nums[index-1] == diff:` because we're trying to find arithmetic progressions where the difference between consecutive elements is the same
<bug_desc>
</bug_desc>
"""
class Solution:
    def numberOfArithmeticSlices(self, nums: List[int]) -> int:
        if len(nums) <= 3:
            return 0
        
        diff =  nums[0] - nums[1] 
        ap_arrays = cur_length = 0
        
        for index in range(1, len(nums)):
            if nums[index] - nums[index-1] != diff:
                cur_length += 1
            else:
                diff = nums[index] - nums[index-1]
                cur_length = 2
            
            if cur_length >= 2:
                ap_arrays += (cur_length - 2)
        
        return ap_arrays
